/*
 * Decompiled with CFR 0.152.
 */
package io.github.cat24a.klowenia_tales.util;

import com.badlogic.gdx.math.Vector2;
import java.util.Optional;

public enum Direction {
    UP(new Vector2(0.0f, 1.0f)),
    DOWN(new Vector2(0.0f, -1.0f)),
    LEFT(new Vector2(-1.0f, 0.0f)),
    RIGHT(new Vector2(1.0f, 0.0f));

    public final Vector2 unit;

    private Direction(Vector2 unit) {
        this.unit = unit;
    }

    public static Optional<Direction> of(Vector2 vector) {
        if (vector.epsilonEquals(Vector2.Zero)) {
            return Optional.empty();
        }
        if (Math.abs(vector.x) > Math.abs(vector.y)) {
            if (vector.x > 0.0f) {
                return Optional.of(RIGHT);
            }
            return Optional.of(LEFT);
        }
        if (vector.y > 0.0f) {
            return Optional.of(UP);
        }
        return Optional.of(DOWN);
    }
}

